/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   System Status OSAPI Implementation Header
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   MPC5xx OS
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __SYSSTAT_H
#define __SYSSTAT_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/


/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)

/* Name: E_OSStatus ClassID:ENUMDEC EnumDflt:"Status Unknown" */
typedef enum
{
    OS_STATUS_BAD = 0,          /* EnumTxt:"Abnormal Operation!" */
    OS_STATUS_OK = 1            /* EnumTxt:"Operating Normally" */
} E_OSStatus;

/* Name: E_OSInternalErrorType ClassID:ENUMDEC EnumDflt:"Unknown Error" */
typedef enum
{
    NO_OS_ERROR,                /* EnumTxt:"NO_OS_ERROR" */
    PROSAK_TPU_ALLOCATE,        /* EnumTxt:"PROSAK_TPU_ALLOCATE" */
    PROSAK_DEADLOCK_PROT,       /* EnumTxt:"PROSAK_DEADLOCK_PROT" */
    QSPI_SEND_SIZE_ZERO,        /* EnumTxt:"QSPI_SEND_SIZE_ZERO" */
    QSPI_SEND_SIZE_TOO_BIG,     /* EnumTxt:"QSPI_SEND_SIZE_TOO_BIG" */
    QSPI_RD_SIZE_TOO_BIG,       /* EnumTxt:"QSPI_RD_SIZE_TOO_BIG" */
    QSPI_RD_SIZE_ZERO,          /* EnumTxt:"QSPI_RD_SIZE_ZERO" */
    QSPI_WR_SIZE_TOO_BIG,       /* EnumTxt:"QSPI_WR_SIZE_TOO_BIG" */
    QSPI_WR_SIZE_ZERO,          /* EnumTxt:"QSPI_WR_SIZE_ZERO" */
    QSPI_CMD_SIZE_TOO_BIG,      /* EnumTxt:"QSPI_CMD_SIZE_TOO_BIG" */
    QSPI_CMD_SIZE_ZERO,         /* EnumTxt:"QSPI_CMD_SIZE_ZERO" */
    IGN_DIAG_MDA_ALLOCATE,      /* EnumTxt:"IGN_DIAG_MDA_ALLOCATE" */
    EE_DATA_SIZE_MISMATCH,      /* EnumTxt:"EEDataDirSizeMisMatch" */
    SPIEE_QUEUE_OVERFLOW,       /* EnumTxt:"EE_WRITE_QUEUE_OVFLOW" */
    ESC_HBRIDGE_MDA_ALLOCATE,   /* EnumTxt:"ESC_HBRIDGE_MDA_ALLOCATE" */
    ETC_DIAG_MDA_ALLOCATE,      /* EnumTxt:"ETC_DIAG_MDA_ALLOCATE" */
    DFLT_ENCODER_CREATE,        /* EnumTxt:"DFLT_ENCODER_CREATE_ERR" */
    ADC_TPU_ALLOCATE,           /* EnumTxt:"ADC_TPU_ALLOCATE" */
    SWISR_QUEUE_OVERFLOW,       /* EnumTxt:"SWISR_QUEUE_OVERFLOW" */
    WATCHDOG_RESET_ERR,         /* EnumTxt:"WATCHDOG_RESET" */
    CHECKSTOP_RESET_ERR,        /* EnumTxt:"CHECKSTOP_RESET" */
    SPIEE_WR_STAT_REG_ERR,      /* EnumTxt:"SPIEE_WR_STAT_REG_ERR" */
    SPIEE_QUEUE_OVFL_STATUS,    /* EnumTxt:"SPIEE_QUEUE_OVFL_STATUS" */
    SPIEE_WRITE_FAIL_ERR,       /* EnumTxt:"SPIEE_WRITE_FAIL_ERR" */
    TPU_FUNC_NOT_IN_MASK,       /* EnumTxt:"Requested TPU Func not in mask" */
    PROSAK_QSPI_ALLOCATE,       /* EnumTxt:"Unable to allocate QSPI knock" */
    STACK_OVERERFLOW,           /* EnumTxt:"Stack has overflowed!" */
    TPU_LIMITS_NOT_SETUP,       /* EnumTxt:"TPU Limits not setup" */
    TPU_MASK_INVALID,           /* EnumTxt:"INVALID TPU MASK" */
    TPU_MASK_CORRUPT,           /* EnumTxt:"TPU Mask Corrupt" */
    SEQ_CREATE_NO_ENC,          /* EnumTxt:"Sequence Create with No Encoder" */
    ILLEGAL_SEQ_ISR,            /* EnumTxt:"Illegal Sequence ISR" */
    BAD_TPU_MASK_VERSION,       /* EnumTxt:"TPU Mask Version is insufficient" */
    NO_MUXPSP_IN_2STROKE,       /* EnumTxt:"MUX PSP requested for 2-Stroke" */
    EXT_FLASH_ACC_DENIED,       /* EnumTxt:"Ext Flash Acc Denied" */
    EXT_FLASH_ERASE_FAIL,       /* EnumTxt:"Ext Flash Erase Fail" */
    EXT_FLASH_WRITE_FAIL,       /* EnumTxt:"Ext Flash Write Fail" */
    EXT_FLASH_MEM_ALLIGN,       /* EnumTxt:"Ext Flash Allign Error" */
    EXT_FLASH_WR_ZERO_SIZE,     /* EnumTxt:"EXT_FLASH_WR_ZERO_SIZE" */
    EXT_FLASH_MEM_ADDR,         /* EnumTxt:"Illegal Ext Flash Addr" */
    EXT_FLASH_NOT_EXIST,        /* EnumTxt:"Error: Write to non-existent Flash" */
    LOG_TOO_MANY_ACTIVE,        /* EnumTxt:"Too many Logs want to be active" */
    BANKSEQ_DESTROY,            /* EnumTxt:"Bank Seq Destroy Problem" */
    TRANSSEQ_DESTROY,           /* EnumTxt:"Transient Seq Destroy Problem" */
    TRANSSEQ_UPDATE,            /* EnumTxt:"Transient Seq Update Problem" */
    OUTOFMEM_SPIEE,             /* EnumTxt:"SPIEE System had a memory problem" */
    SYNC_SPIEE_TOO_LONG,        /* EnumTxt:"Spent too long waiting for a sync return" */
    TPU_MASK_MISMATCH,          /* EnumTxt:"TPUC Mask does not pair with TPUA/B mask" */
    MODULECONFIGURATION_MISSING,/* EnumTxt:"The Module Configuration was not available" */
    SEQ_DIAG_MUX,               /* EnumTxt:"Diagnostic Mux did not create" */
    FGND_ANGLE_QUEUE_OVERFLOW,  /* EnumTxt:"FGND Angle event queue overflow" */
    FGND_TIME_QUEUE_OVERFLOW,   /* EnumTxt:"FGND Time event queue overflow" */
    CAM_DELAY_WRITE,            /* EnumTxt:"EEPROM write to CAMDelay failed" */
    KERNEL_SLEEP_FROM_ISR,      /* EnumTxt:"SleepTask call from in ISR" */ 
    KERNEL_API_USAGE,           /* EnumTxt:"Bad Kernel API call detected" */
    KERNEL_INTERNAL,            /* EnumTxt:"Kernel Internal" */
    SPIEE_CREATE,               /* EnumTxt:"SPIEE Device create" */
    NAND_TIMEOUT_WRITE,         /* EnumTxt:"NAND Flash timeout on Write" */
    NAND_TIMEOUT_ERASE,         /* EnumTxt:"NAND Flash timeout on Erase" */
    NAND_BAD_WP,                /* EnumTxt:"NAND Flash WP" */
    NAND_BAD_READY_BUSY,        /* EnumTxt:"NAND Flash RDY/BUSYb" */
    NAND_BAD_ACCESS,            /* EnumTxt:"NAND Flash Access" */
    NAND_BAD_DEVICE,            /* EnumTxt:"NAND Flash Device" */
    USB_CORE_INIT,              /* EnumTxt:"USB Core Stack Initialisation" */
    USB_STACK_ASSERT,           /* EnumTxt:"USB Stack Assert" */
    EXT_EE_ACCESS,              /* EnumTxt:"EXT_EE_ACCESS" */
    VARCAM_PATTERN_SETUP,       /* EnumTxt:"VARCAM_PATTERN_SETUP" */
    FP_DIVIDE_BY_ZERO_ERROR,    /* EnumTxt:"FP Divide by Zero" */
    OUTOFMEM_HEAP,              /* EnumTxt:"Unable to allocate requested memory on heap" */
    FGND_ANGLE_TASKCREATE,      /* EnumTxt:"Unable create Fgnd Angle task" */
    FP_DENORMALIZED_NUM,        /* EnumTxt:"FP Denormalized number" */
    OSERR_RPMVECTOR_FULL,       /* EnumTxt:"RPMVector Buffers Full" */
    OSERR_RPMVECTOR_OVERRUN,    /* EnumTxt:"RPMVector Overrun" */
    TPU_SM_FAIL,                /* EnumTxt:"Failed to Write TPU Self Modify Parameter" */
    NUM_OS_ERROR_TYPES
} E_OSInternalErrorType;

#pragma pack()

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
void ClearSystemStatus(void);
void SendUncontrolShutdownProtOSMessage(void);
void SendUncontrolShutdownUnProtOSMessage(void);
void UncontrolShutdownProtCback(void);

#endif /* __SYSSTAT_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/

